# arcsine.R
# One-way ANOVA for proportions

# Load necessary libraries
library(ggplot2)

# Read in data set
arcdata <- read.table(header=T,colClasses=c("factor","numeric"),text="
predators survivors
0 18
0 18
0 18
0 16
0 19
0 19
0 17
0 18
0 20
0 17
10 14
10 17
10 15
10 10
10 17
10 14
10 13
10 17
10 14
10 15
20 12
20 16
20 16
20 12
20 6
20 12
20 13
20 10
20 9
20 10
")

# Apply transformations here
arcdata <- transform(arcdata,prop=survivors/20)
arcdata <- transform(arcdata,y=asin(sqrt(prop)))

# Print data
arcdata

# Graphics using ggplot2
ggplot(arcdata,aes(predators,y))+
geom_jitter(size=2,position=position_jitter(width=0.1))+
stat_summary(fun="mean",geom="point",size=3)+
stat_summary(fun.data="mean_cl_normal",geom="errorbar",width=0.2,linewidth=1)

# One-way ANOVA
aovout <- aov(y~predators,data=arcdata)
anova(aovout)

# Diagnostic plots to check ANOVA assumptions
p <- predict(aovout)
r <- resid(aovout)
plot(p,r)
qqnorm(r)
